/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class EntryBackupInfo
extends BaseFssApiResource {
    @Schema(description="If true, backup folder is connected to the HCP Anywhere desktop application")
    private Boolean isActive;
    @Schema(description="If true, the item is a mount point, also known as mounted filesystem within the HCP Anywhere filesystem")
    private Boolean isMountPoint;
    @Schema(description="The type of device which the desktop application is installed (WINDOWS, WINDOWS NSC, or MAC)")
    private String operatingSystem;
    @Schema(description="If true, the backup folder has an associated desktop application")
    private Boolean hasAssociatedClient;

    public static Class<? extends EntryBackupInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static EntryBackupInfo create(FssApiVersion apiVersion, Boolean isActive, Boolean isMountPoint, String operatingSystem, Boolean hasAssociatedClient) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, isActive, isMountPoint, operatingSystem, hasAssociatedClient);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, isActive, isMountPoint, operatingSystem);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private EntryBackupInfo() {
    }

    private EntryBackupInfo(Boolean isActive, Boolean isMountPoint, String operatingSystem, Boolean hasAssociatedClient) {
        this.isActive = isActive;
        this.isMountPoint = isMountPoint;
        this.operatingSystem = operatingSystem;
        this.hasAssociatedClient = hasAssociatedClient;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsMountPoint() {
        return this.isMountPoint;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public Boolean hasAssociatedClient() {
        return this.hasAssociatedClient;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EntryBackupInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EntryBackupInfo e = (EntryBackupInfo)o;
        return Objects.equal((Object)this.getIsActive(), (Object)e.getIsActive()) && Objects.equal((Object)this.getIsMountPoint(), (Object)e.getIsMountPoint()) && Objects.equal((Object)this.getOperatingSystem(), (Object)e.getOperatingSystem()) && Objects.equal((Object)this.hasAssociatedClient(), (Object)e.hasAssociatedClient());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getIsMountPoint(), this.getIsActive(), this.getOperatingSystem()});
    }

    private static class V303
    extends EntryBackupInfo {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, Boolean isActive, Boolean isMountPoint, String operatingSystem, Boolean hasAssociatedClient) {
            super(isActive, isMountPoint, operatingSystem, hasAssociatedClient);
        }
    }

    private static class V300
    extends EntryBackupInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean isActive, Boolean isMountPoint, String operatingSystem) {
            super(isActive, isMountPoint, operatingSystem, null);
        }
    }
}

