/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;

public abstract class EntryIdentifier
extends BaseFssApiResource {
    private String path;
    private String etag;

    public static Class<? extends EntryIdentifier> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static EntryIdentifier create(FssApiVersion apiVersion, String path, String etag) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(path, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private EntryIdentifier(String path, String etag) {
        this.path = path;
        this.etag = etag;
    }

    private EntryIdentifier() {
    }

    public String getPath() {
        return this.path;
    }

    public String getEtag() {
        return this.etag;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V303
    extends EntryIdentifier {
        private V303() {
        }

        private V303(String path, String etag) {
            super(path, etag);
        }
    }
}

