/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FilesystemType;
import com.hds.hcpaw.fss.api.model.TeamFolderInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class EntrySharingInfo
extends BaseFssApiResource {
    @Schema(description="If true, user is Owner of the shared folder or Manager of the team folder")
    private Boolean canUserManage;
    @Schema(description="If true, the item is a mount point, also known as mounted filesystem within the HCP Anywhere filesystem")
    private Boolean isMountPoint;
    @Schema(description="True if sync is enabled")
    private Boolean sync;
    @Schema(description="If the item is a shared or team folder, the label of the folder")
    private String label;
    @Schema(description="The type of collaborative folder (PRIVATE, SHARED, TEAM, MOBILIZED, or BACKUP)")
    private FilesystemType type;
    @Schema(description="If the item is a team folder, provides additional team folder information")
    private TeamFolderInfo teamFolderInfo;
    @Schema(description="True if last team folder manager")
    private Boolean isLastTeamFolderManager;
    @Schema(description="The team folder request information")
    private TeamFolderInfo teamFolderRequest;
    @Schema(description="Time to keep folder for")
    private Long retentionTime;
    @Schema(description="Policy in which to enforce entry retention")
    private String retentionPolicy;

    public static Class<? extends EntrySharingInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return V310.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static EntrySharingInfo create(FssApiVersion apiVersion, Boolean canUserManage, Boolean isMountPoint, FilesystemType type, String label, TeamFolderInfo teamFolderInfo, Boolean sync, TeamFolderInfo teamFolderRequest, Boolean isLastTeamFolderManager, Long retentionTime, String retentionPolicy) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_430)) {
            return new V420(apiVersion, canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest, isLastTeamFolderManager, retentionTime, retentionPolicy);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return new V310(apiVersion, canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest, isLastTeamFolderManager);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private EntrySharingInfo() {
    }

    private EntrySharingInfo(Boolean canUserManage, Boolean isMountPoint, FilesystemType type, String label, TeamFolderInfo teamFolderInfo, Boolean sync, TeamFolderInfo teamFolderRequest, Boolean isLastTeamFolderManager, Long retentionTime, String retentionPolicy) {
        this.canUserManage = canUserManage;
        this.isMountPoint = isMountPoint;
        this.type = type;
        this.teamFolderInfo = teamFolderInfo;
        this.label = label;
        this.sync = sync;
        this.teamFolderRequest = teamFolderRequest;
        this.isLastTeamFolderManager = isLastTeamFolderManager;
        this.retentionTime = retentionTime;
        this.retentionPolicy = retentionPolicy;
    }

    public Boolean getCanUserManage() {
        return this.canUserManage;
    }

    public TeamFolderInfo getTeamFolderInfo() {
        return this.teamFolderInfo;
    }

    public Boolean getIsMountPoint() {
        return this.isMountPoint;
    }

    public FilesystemType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public TeamFolderInfo getTeamFolderRequest() {
        return this.teamFolderRequest;
    }

    public Boolean getIsLastTeamFolderManager() {
        return this.isLastTeamFolderManager;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public Long getRetentionTime() {
        return this.retentionTime;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EntrySharingInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EntrySharingInfo e = (EntrySharingInfo)o;
        return Objects.equal((Object)this.getIsMountPoint(), (Object)e.getIsMountPoint()) && Objects.equal((Object)this.getCanUserManage(), (Object)e.getCanUserManage()) && Objects.equal((Object)((Object)this.getType()), (Object)((Object)e.getType())) && Objects.equal((Object)this.getLabel(), (Object)e.getLabel()) && Objects.equal((Object)this.getTeamFolderInfo(), (Object)e.getTeamFolderInfo()) && Objects.equal((Object)this.getSync(), (Object)e.getSync()) && Objects.equal((Object)this.getTeamFolderRequest(), (Object)e.getTeamFolderRequest()) && Objects.equal((Object)this.getIsLastTeamFolderManager(), (Object)e.getIsLastTeamFolderManager());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getIsMountPoint(), this.getCanUserManage(), this.getType(), this.getLabel(), this.getTeamFolderInfo(), this.getSync()});
    }

    private static class V420
    extends EntrySharingInfo {
        public V420(FssApiVersion apiVersion, Boolean canUserManage, Boolean isMountPoint, FilesystemType type, String label, TeamFolderInfo teamFolderInfo, Boolean sync, TeamFolderInfo teamFolderRequest, Boolean isLastTeamFolderManager, Long retentionTime, String retentionPolicy) {
            super(canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest, isLastTeamFolderManager, retentionTime, retentionPolicy);
        }
    }

    private static class V310
    extends EntrySharingInfo {
        private V310() {
        }

        private V310(FssApiVersion apiVersion, Boolean canUserManage, Boolean isMountPoint, FilesystemType type, String label, TeamFolderInfo teamFolderInfo, Boolean sync, TeamFolderInfo teamFolderRequest, Boolean isLastTeamFolderManager) {
            super(canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest, isLastTeamFolderManager, null, null);
        }
    }

    private static class V300
    extends EntrySharingInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean canUserManage, Boolean isMountPoint, FilesystemType type, String label, TeamFolderInfo teamFolderInfo, Boolean sync, TeamFolderInfo teamFolderRequest) {
            super(canUserManage, isMountPoint, type, label, teamFolderInfo, sync, teamFolderRequest, null, null, null);
        }
    }
}

