/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.exception.FssApiError;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.io.InputStreamReader;

public class ErrorMessage
extends BaseFssApiResource {
    private final FssApiError error;
    @SerializedName(value="error_description")
    private final String description;

    public static Class<? extends ErrorMessage> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ErrorMessage create(FssApiVersion apiVersion, FssApiError error, String description) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(error, description);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ErrorMessage createLatest(FssApiError error, String description) {
        return new V211(error, description);
    }

    private ErrorMessage(FssApiError error, String description) {
        this.error = error;
        this.description = description;
    }

    public FssApiError getError() {
        return this.error;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ErrorMessage.class).add("error", (Object)this.error).add("description", (Object)this.description).toString();
    }

    public static ErrorMessage create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return ErrorMessage.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V211
    extends ErrorMessage {
        private V211(FssApiError error, String description) {
            super(error, description);
        }
    }
}

