/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class FileAccessEntry
extends BaseFssApiResource {
    @Schema(description="The name of the file that was accessed", required=true)
    private String filename;
    @Schema(description="The username of the person who accessed the link", required=true)
    private String username;
    @Schema(description="The size of the file in bytes", required=true)
    private Long size;
    @Schema(description="The time at which the event occurred (returned in Unix format)", required=true)
    private Long timestamp;
    @Schema(description="Nanoseconds associated with the timestamp")
    private transient int nanos;
    @Schema(description="Timestamp qualifier")
    private transient Short tsExtra;

    public static Class<? extends FileAccessEntry> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static FileAccessEntry create(FssApiVersion apiVersion, String filename, String username, Long size, Long timestamp, int nanos, Short tsExtra) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(filename, username, size, timestamp, nanos, tsExtra);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileAccessEntry(String filename, String username, Long size, Long timestamp, int nanos, Short tsExtra) {
        this.filename = filename;
        this.username = username;
        this.size = size;
        this.timestamp = timestamp;
        this.nanos = nanos;
        this.tsExtra = tsExtra;
    }

    private FileAccessEntry() {
    }

    public String getFilename() {
        return this.filename;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public int getNanos() {
        return this.nanos;
    }

    public Short getTsExtra() {
        return this.tsExtra;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAccessEntry e = (FileAccessEntry)o;
        return Objects.equal((Object)this.getFilename(), (Object)e.getFilename()) && Objects.equal((Object)this.getUsername(), (Object)e.getUsername()) && Objects.equal((Object)this.getSize(), (Object)e.getSize()) && Objects.equal((Object)this.getTimestamp(), (Object)e.getTimestamp()) && Objects.equal((Object)this.getNanos(), (Object)e.getNanos()) && Objects.equal((Object)this.getTsExtra(), (Object)e.getTsExtra());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFilename(), this.getUsername(), this.getSize(), this.getTimestamp(), this.getNanos(), this.getTsExtra()});
    }

    private static class V300
    extends FileAccessEntry {
        private V300() {
        }

        private V300(String filename, String username, Long size, Long timestamp, int nanos, Short tsExtra) {
            super(filename, username, size, timestamp, nanos, tsExtra);
        }
    }
}

