/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStream;

public abstract class FileCreateRequest
extends BaseFssApiResource {
    @Schema(description="The path of the file you want to upload", required=true)
    private String path;
    @Schema(description="The size (in bytes) of the file being uploaded.")
    private Long size;
    @Schema(description="The hex encoded SHA-384 hash of the file being uploaded")
    private String hash;
    @Schema(description="True if any parent folders of path that do not already exist should be created; false otherwise")
    private Boolean createParents;
    @Schema(description="The modification time of the file")
    private Long mtime;
    @Schema(description="The creation time of the file")
    private Long ctime;
    @Schema(description="The last access time of the file")
    private Long atime;
    @Schema(description="The InputStream (file) to be uploaded", required=true)
    private InputStream input;

    public static Class<? extends FileCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileCreateRequest create(FssApiVersion apiVersion, String path, Long size, String hash, Boolean createParents, Long mtime, Long ctime, Long atime, InputStream input) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, size, hash, createParents, mtime, ctime, atime, input);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileCreateRequest(String path, Long size, String hash, Boolean createParents, Long mtime, Long ctime, Long atime, InputStream input) {
        this.path = path;
        this.size = size;
        this.hash = hash;
        this.createParents = createParents;
        this.mtime = mtime;
        this.ctime = ctime;
        this.atime = atime;
        this.input = input;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("input", this.input, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getCreateParents() {
        return this.createParents;
    }

    public Long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getMtime() {
        return this.mtime;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public Long getAtime() {
        return this.atime;
    }

    public InputStream getInput() {
        return this.input;
    }

    private static class V211
    extends FileCreateRequest {
        private V211(String path, Long size, String hash, Boolean createParents, Long mtime, Long ctime, Long atime, InputStream input) {
            super(path, size, hash, createParents, mtime, ctime, atime, input);
        }
    }
}

