/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Strings;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.PageAction;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FileHistoryListingRequest
extends BaseFssApiResource {
    @Schema(description="The path to the file", required=true)
    private String path;
    @Schema(description="If true, only access events that occurred while user was a member of the shared folder are returned")
    private Boolean showPrivate;
    @Schema(description="The page token identifies where in the list of events you are")
    private String pageToken;
    @Schema(description="The maximum number of items to return in the request (default is 100)")
    private Integer pageSize;
    @Schema(description="The portion of the events to return")
    private PageAction pageAction;

    public static Class<? extends FileHistoryListingRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileHistoryListingRequest create(FssApiVersion apiVersion, String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, showPrivate, pageToken, pageSize, pageAction);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileHistoryListingRequest(String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) {
        this.path = path;
        this.showPrivate = showPrivate;
        this.pageToken = pageToken;
        this.pageSize = pageSize;
        this.pageAction = pageAction;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        if (Strings.isNullOrEmpty((String)this.pageToken)) {
            this.validateFieldNotNull("path", this.path, fieldName);
        }
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getShowPrivate() {
        return this.showPrivate;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PageAction getPageAction() {
        return this.pageAction;
    }

    private static class V300
    extends FileHistoryListingRequest {
        private V300(FssApiVersion apiVersion, String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) {
            super(path, showPrivate, pageToken, pageSize, pageAction);
        }
    }
}

