/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class FileReadRequest
extends BaseFssApiResource {
    @Schema(description="The path of the file you want to download", required=true)
    private String path;
    @Schema(description="The etag identifies the version of the file and is part of the file metadata")
    private String etag;
    @Schema(description="If an etag is included in the request and forceDownload is set to true, the version of the file that relates to the etag is returned, even if the etag identifies an older version of the file (default is false)")
    private Boolean forceDownload;

    public static Class<? extends FileReadRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileReadRequest create(FssApiVersion apiVersion, String path, String etag, Boolean forceDownload) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, etag, forceDownload);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileReadRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return FileReadRequest.fromJson(apiVersion, reader, V300.class);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return FileReadRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileReadRequest() {
    }

    private FileReadRequest(String path, String etag, Boolean forceDownload) {
        this.path = path;
        this.etag = etag;
        this.forceDownload = forceDownload;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getEtag() {
        return this.etag;
    }

    public Boolean getForceDownload() {
        return this.forceDownload;
    }

    private static class V300
    extends FileReadRequest {
        private V300() {
        }

        private V300(String path, String etag, Boolean forceDownload) {
            super(path, etag, forceDownload);
        }
    }

    private static class V211
    extends FileReadRequest {
        private V211() {
        }

        private V211(String path, String etag) {
            super(path, etag, false);
        }
    }
}

