/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStream;

public abstract class FileUpdateRequest
extends BaseFssApiResource {
    @Schema(description="The path of the file you want to update", required=true)
    private String path;
    @Schema(description="The size (in bytes) of the file being uploaded.")
    private Long size;
    @Schema(description="The hex encoded SHA-384 hash of the file being uploaded")
    private String hash;
    @Schema(description="The etag identifies the version of the file and is part of the file metadata")
    private String etag;
    @Schema(description="The modification time of the file or folder")
    private Long changeTime;
    @Schema(description="The last access time of the file or folder")
    private Long accessTime;
    @Schema(description="Contents to update file with")
    private InputStream input;

    public static Class<? extends FileUpdateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileUpdateRequest create(FssApiVersion apiVersion, String path, Long size, String hash, String etag, Long changeTime, Long accessTime, InputStream input) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, size, hash, etag, changeTime, accessTime, input);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileUpdateRequest() {
    }

    private FileUpdateRequest(String path, Long size, String hash, String etag, Long changeTime, Long accessTime, InputStream input) {
        this.path = path;
        this.size = size;
        this.hash = hash;
        this.etag = etag;
        this.changeTime = changeTime;
        this.accessTime = accessTime;
        this.input = input;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("etag", this.etag, fieldName);
        this.validateFieldNotNull("input", this.input, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getChangeTime() {
        return this.changeTime;
    }

    public Long getAccessTime() {
        return this.accessTime;
    }

    public String getHash() {
        return this.hash;
    }

    public InputStream getInput() {
        return this.input;
    }

    private static class V211
    extends FileUpdateRequest {
        private V211() {
        }

        private V211(String path, Long size, String hash, String etag, Long changeTime, Long accessTime, InputStream input) {
            super(path, size, hash, etag, changeTime, accessTime, input);
        }
    }
}

