/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FileVersionEntry
extends BaseFssApiResource {
    @Schema(description="The event that caused the version to be created", required=true)
    private String event;
    @Schema(description="Argument associated with the event string")
    private String eventArg;
    @Schema(description="The user's username. The username is acquired from the authentication provider (SAML or AD) of that user.", required=true)
    private String username;
    @Schema(description="The size of the file in bytes", required=true)
    private Long size;
    @Schema(description="The time at which the version was created (returned in Unix format)", required=true)
    private Long timestamp;
    @Schema(description="Nanoseconds associated with the timestamp")
    private transient int nanos;
    @Schema(description="Timestamp qualifier")
    private transient Short tsExtra;
    @Schema(description="If true, the version listed is the current version of the file", required=true)
    private Boolean currentVersion;
    @Schema(description="The etag identifies the version of the file and is supplied as a parameter in some of the other File Sync and Share API endpoints", required=true)
    private String etag;

    public static Class<? extends FileVersionEntry> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static FileVersionEntry create(FssApiVersion apiVersion, String event, String username, Long size, Long timestamp, int nanos, Short tsExtra, Boolean currentVersion, String etag, String eventArg) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(event, username, size, timestamp, nanos, tsExtra, currentVersion, etag, eventArg);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(event, username, size, timestamp, nanos, tsExtra, currentVersion, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileVersionEntry(String event, String username, Long size, Long timestamp, int nanos, Short tsExtra, Boolean currentVersion, String etag, String eventArg) {
        this.event = event;
        this.eventArg = eventArg;
        this.username = username;
        this.size = size;
        this.timestamp = timestamp;
        this.nanos = nanos;
        this.tsExtra = tsExtra;
        this.currentVersion = currentVersion;
        this.etag = etag;
    }

    private FileVersionEntry() {
    }

    public String getEvent() {
        return this.event;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getSize() {
        return this.size;
    }

    public Boolean isCurrentVersion() {
        return this.currentVersion;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public int getNanos() {
        return this.nanos;
    }

    public Short getTsExtra() {
        return this.tsExtra;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getEventArg() {
        return this.eventArg;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FileVersionEntry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        FileVersionEntry e = (FileVersionEntry)o;
        return Objects.equal((Object)this.getEvent(), (Object)e.getEvent()) && Objects.equal((Object)this.getUsername(), (Object)e.getUsername()) && Objects.equal((Object)this.getSize(), (Object)e.getSize()) && Objects.equal((Object)this.getTimestamp(), (Object)e.getTimestamp()) && Objects.equal((Object)this.getNanos(), (Object)e.getNanos()) && Objects.equal((Object)this.getTsExtra(), (Object)e.getTsExtra()) && this.isCurrentVersion() == e.isCurrentVersion() && Objects.equal((Object)this.getEtag(), (Object)e.getEtag());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getEvent(), this.getUsername(), this.getSize(), this.getTimestamp(), this.getNanos(), this.getTsExtra(), this.isCurrentVersion(), this.getEtag()});
    }

    private static class V303
    extends FileVersionEntry {
        private V303() {
        }

        private V303(String event, String username, Long size, Long timestamp, int nanos, Short tsExtra, Boolean currentVersion, String etag, String eventArg) {
            super(event, username, size, timestamp, nanos, tsExtra, currentVersion, etag, eventArg);
        }
    }

    private static class V300
    extends FileVersionEntry {
        private V300() {
        }

        private V300(String event, String username, Long size, Long timestamp, int nanos, Short tsExtra, Boolean currentVersion, String etag) {
            super(event, username, size, timestamp, nanos, tsExtra, currentVersion, etag, null);
        }
    }
}

