/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FileVersionEntry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class FileVersionListing
extends BaseFssApiResource {
    @Schema(description="A page token is returned in every response and identifies where in the list of versions you are")
    private String pageToken;
    @Schema(description="The versions of the file")
    private List<FileVersionEntry> entries;

    public static Class<? extends FileVersionListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static FileVersionListing create(FssApiVersion apiVersion, List<FileVersionEntry> members, String token) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(members, token);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileVersionListing(List<FileVersionEntry> entries, String token) {
        this.entries = entries;
        this.pageToken = token;
    }

    private FileVersionListing() {
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<FileVersionEntry> getEntries() {
        return this.entries;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    private static class V300
    extends FileVersionListing {
        private V300(List<FileVersionEntry> members, String token) {
            super(members, token);
        }
    }
}

