/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FileVersionPromoteRequest
extends BaseFssApiResource {
    @Schema(description="The path to the file", required=true)
    private String path;
    @Schema(description="The etag identifies the version of the file", required=true)
    private String etag;

    public static Class<? extends FileVersionPromoteRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FileVersionPromoteRequest create(FssApiVersion apiVersion, String path, String etag) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FileVersionPromoteRequest(String path, String etag) {
        this.path = path;
        this.etag = etag;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("etag", this.etag, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getEtag() {
        return this.etag;
    }

    private static class V300
    extends FileVersionPromoteRequest {
        private V300(FssApiVersion apiVersion, String path, String etag) {
            super(path, etag);
        }
    }
}

