/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FilesActivityEntry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class FilesActivity
extends BaseFssApiResource {
    @Schema(description="The list of events", required=true)
    private List<FilesActivityEntry> activities;
    @Schema(description="The page token identifies where in the list of events you are")
    private String pageToken;

    public static Class<? extends FilesActivity> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FilesActivity create(FssApiVersion apiVersion, List<FilesActivityEntry> activities, String pageToken) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, activities, pageToken);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FilesActivity() {
    }

    private FilesActivity(List<FilesActivityEntry> activities, String pageToken) {
        this.activities = activities;
        this.pageToken = pageToken;
    }

    public List<FilesActivityEntry> getActivities() {
        return this.activities;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends FilesActivity {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, List<FilesActivityEntry> activities, String pageToken) {
            super(activities, pageToken);
        }
    }
}

