/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FilesActivityEntry
extends BaseFssApiResource {
    @Schema(description="Information about the file or folder that the event is about", required=true)
    private Entry entry;
    @Schema(description="Describes the event", required=true)
    private String msg;
    @Schema(description="The time at which the event occurred (returned in Unix format)", required=true)
    private Long timestamp;
    @Schema(description="Nanoseconds associated with the timestamp", required=true)
    private transient Integer nanos;
    @Schema(description="The timestamp disambiguating short", required=true)
    private transient Short tsExtra;
    @Schema(description="If true, the file has been pruned from the HCP Anywhere system", required=true)
    private Boolean isPruned;

    public static Class<? extends FilesActivityEntry> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FilesActivityEntry create(FssApiVersion apiVersion, Entry entry, String msg, Long timestamp, Integer nanos, Short tsExtra, Boolean isPruned) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, entry, msg, timestamp, nanos, tsExtra, isPruned);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, entry, msg, timestamp, nanos, tsExtra);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FilesActivityEntry() {
    }

    private FilesActivityEntry(Entry entry, String msg, Long timestamp, Integer nanos, Short tsExtra, Boolean isPruned) {
        this.entry = entry;
        this.msg = msg;
        this.timestamp = timestamp;
        this.nanos = nanos;
        this.tsExtra = tsExtra;
        this.isPruned = isPruned;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String getMsg() {
        return this.msg;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getNanos() {
        return this.nanos;
    }

    public Short getTsExtra() {
        return this.tsExtra;
    }

    public Boolean getIsPruned() {
        return this.isPruned;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends FilesActivityEntry {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Entry entry, String msg, Long timestamp, Integer nanos, Short tsExtra) {
            super(entry, msg, timestamp, nanos, tsExtra, null);
        }
    }

    private static class V303
    extends FilesActivityEntry {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, Entry entry, String msg, Long timestamp, Integer nanos, Short tsExtra, Boolean isPruned) {
            super(entry, msg, timestamp, nanos, tsExtra, isPruned);
        }
    }
}

