/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Strings;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.PageAction;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class FilesActivityRequest
extends BaseFssApiResource {
    @Schema(description="The type of events that are returned", required=true)
    private FilesActivityType activityType;
    @Schema(description="The unique identifying string of the given user's filesystem")
    private String fsId;
    @Schema(description="The page token identifies where in the list of events you are")
    private String pageToken;
    @Schema(description="The maximum number of items to return in the request (default is 100)")
    private Integer pageSize;
    @Schema(description="The portion of the events to return")
    private PageAction pageAction;
    @Schema(description="The language of the events (default is English)")
    private String language;

    public static Class<? extends FilesActivityRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FilesActivityRequest create(FssApiVersion apiVersion, FilesActivityType activityType, String fsId, String pageToken, Integer pageSize, PageAction pageAction, String language) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, activityType, fsId, pageToken, pageSize, pageAction, language);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, activityType, fsId, pageToken, pageSize, pageAction);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FilesActivityRequest() {
    }

    private FilesActivityRequest(FilesActivityType activityType, String fsId, String pageToken, Integer pageSize, PageAction pageAction, String language) {
        this.activityType = activityType;
        this.fsId = fsId;
        this.pageToken = pageToken;
        this.pageSize = pageSize;
        this.pageAction = pageAction;
        this.language = language;
    }

    public FilesActivityType getActivityType() {
        return this.activityType;
    }

    public String getFsId() {
        return this.fsId;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PageAction getPageAction() {
        return this.pageAction;
    }

    public String getLanguage() {
        return StringEscapeUtils.escapeHtml4((String)this.language);
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
        if (Strings.isNullOrEmpty((String)this.pageToken)) {
            this.validateFieldNotNull("activityType", (Object)this.activityType, fieldName);
            this.validateFieldNotNull("fsId", this.fsId, fieldName);
        }
        if (!Strings.isNullOrEmpty((String)this.language)) {
            this.validateLocale("language", this.language, null);
        }
    }

    private static class V303
    extends FilesActivityRequest {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, FilesActivityType activityType, String fsId, String pageToken, Integer pageSize, PageAction pageAction, String language) {
            super(activityType, fsId, pageToken, pageSize, pageAction, language);
        }
    }

    private static class V300
    extends FilesActivityRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, FilesActivityType activityType, String fsId, String pageToken, Integer pageSize, PageAction pageAction) {
            super(activityType, fsId, pageToken, pageSize, pageAction, null);
        }
    }

    public static enum FilesActivityType {
        MODIFY,
        READ_LINK,
        READ;

    }
}

