/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FilesystemType;
import com.hds.hcpaw.fss.api.model.OwnerInfo;
import com.hds.hcpaw.fss.api.model.TeamFolderInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FilesystemInfo
extends BaseFssApiResource {
    @Schema(description="The path to the filesystem")
    private String path;
    @Schema(description="A unique identifying string assigned to the filesystem by HCP Anywhere")
    private String fsId;
    @Schema(description="The type of filesystem")
    private FilesystemType type;
    @Schema(description="Information about the owner of the filesystem")
    private OwnerInfo ownerInfo;
    @Schema(description="The additional settings that apply to team folders")
    private TeamFolderInfo teamFolder;

    public static Class<? extends FilesystemInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FilesystemInfo create(FssApiVersion apiVersion, String path, String fsId, FilesystemType type, OwnerInfo ownerInfo, TeamFolderInfo teamFolder) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, fsId, type, ownerInfo, teamFolder);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FilesystemInfo() {
    }

    private FilesystemInfo(String path, String fsId, FilesystemType type, OwnerInfo ownerInfo, TeamFolderInfo teamFolder) {
        this.path = path;
        this.fsId = fsId;
        this.type = type;
        this.ownerInfo = ownerInfo;
        this.teamFolder = teamFolder;
    }

    public String getPath() {
        return this.path;
    }

    public String getFsId() {
        return this.fsId;
    }

    public FilesystemType getType() {
        return this.type;
    }

    public OwnerInfo getOwnerInfo() {
        return this.ownerInfo;
    }

    public TeamFolderInfo getTeamFolder() {
        return this.teamFolder;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends FilesystemInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, String fsId, FilesystemType type, OwnerInfo ownerInfo, TeamFolderInfo teamFolder) {
            super(path, fsId, type, ownerInfo, teamFolder);
        }
    }
}

