/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FilesystemInfo;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class FilesystemListing
extends BaseFssApiResource {
    @Schema(description="List of file systems")
    private List<FilesystemInfo> filesystems;

    public static Class<? extends FilesystemListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static FilesystemListing create(FssApiVersion apiVersion, List<FilesystemInfo> filesystems) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(filesystems);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FilesystemListing(List<FilesystemInfo> filesystems) {
        this.filesystems = filesystems;
    }

    private FilesystemListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<FilesystemInfo> getFilesystems() {
        return this.filesystems;
    }

    private static class V300
    extends FilesystemListing {
        private V300() {
        }

        private V300(List<FilesystemInfo> filesystems) {
            super(filesystems);
        }
    }
}

