/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class FolderCreateRequest
extends BaseFssApiResource {
    @Schema(description="The path of the folder you want to create", required=true)
    private String path;
    @Schema(description="If true, request creates any folders that do not exist in the path specified")
    private Boolean createParents;
    @Schema(description="The modification time of the file or folder (must be supplied in Unix Epoch time)")
    private Long mtime;
    @Schema(description="The creation time of the file or folder (must be supplied in Unix Epoch time)")
    private Long ctime;
    @Schema(description="The last access time of the file or folder (must be supplied in Unix Epoch time)")
    private Long atime;

    public static Class<? extends FolderCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderCreateRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return FolderCreateRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderCreateRequest create(FssApiVersion apiVersion, String path, Boolean createParents, Long mtime, Long ctime, Long atime) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, createParents, mtime, ctime, atime);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderCreateRequest() {
    }

    private FolderCreateRequest(String path, Boolean createParents, Long mtime, Long ctime, Long atime) {
        this.path = path;
        this.createParents = createParents;
        this.mtime = mtime;
        this.ctime = ctime;
        this.atime = atime;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public Long getMtime() {
        return this.mtime;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public Long getAtime() {
        return this.atime;
    }

    public Boolean getCreateParents() {
        return this.createParents;
    }

    private static class V211
    extends FolderCreateRequest {
        private V211() {
        }

        private V211(String path, Boolean createParents, Long mtime, Long ctime, Long atime) {
            super(path, createParents, mtime, ctime, atime);
        }
    }
}

