/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class FolderListing
extends BaseFssApiResource {
    @Schema(description="A page token is returned in every response and identifies where in the list of folder items you are", required=true)
    private String pageToken;
    @Schema(description="A list of the items in the folder", required=true)
    private List<Entry> entries;

    public static Class<? extends FolderListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static FolderListing create(FssApiVersion apiVersion, String pageToken, List<Entry> entries) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(pageToken, entries);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderListing(String pageToken, List<Entry> entries) {
        this.pageToken = pageToken;
        this.entries = entries;
    }

    private FolderListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    private static class V211
    extends FolderListing {
        private V211() {
        }

        private V211(String pageToken, List<Entry> entries) {
            super(pageToken, entries);
        }
    }
}

