/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Strings;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class FolderListingRequest
extends BaseFssApiResource {
    @Schema(description="The path to the folder", required=true)
    private String path;
    @Schema(description="The page token identifies where in the list of items you are")
    private String pageToken;
    @Schema(description="The maximum number of items to return in a request (default is 100)")
    private Integer pageSize;
    @Schema(description="The point in time at which to list the items (must be supplied in Unix format in milliseconds)")
    private Long viewAtTime;
    @Schema(description="If true, items that have been deleted in the folder and are still in the system are returned along with the existing items")
    private Boolean includeDeleted;
    @Schema(description="The way in which the items are sorted in the response body (NAME, MODIFY_DATE or SIZE)")
    private SortingCriterion sortingCriterion;
    @Schema(description="The direction in which the list is sorted (ASC or DESC)")
    private SortingDirection sortingDirection;

    public static Class<? extends FolderListingRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderListingRequest create(FssApiVersion apiVersion, String path, String pageToken, Integer pageSize, Long viewAtTime, Boolean includeDeleted, SortingCriterion sortingCriterion, SortingDirection sortingDirection) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, pageToken, pageSize, viewAtTime, includeDeleted, sortingCriterion, sortingDirection);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, pageToken, pageSize);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderListingRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return FolderListingRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderListingRequest() {
    }

    private FolderListingRequest(String path, String pageToken, Integer pageSize, Long viewAtTime, Boolean includeDeleted, SortingCriterion sortingCriterion, SortingDirection sortingDirection) {
        this.path = path;
        this.pageToken = pageToken;
        this.pageSize = pageSize;
        this.viewAtTime = viewAtTime;
        this.includeDeleted = includeDeleted;
        this.sortingCriterion = sortingCriterion;
        this.sortingDirection = sortingDirection;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
        if (this.path == null) {
            this.validateFieldNotNull("pageToken", this.pageToken, fieldName);
        } else if (Strings.isNullOrEmpty((String)this.pageToken)) {
            this.validateFieldNotNull("path", this.path, fieldName);
        }
        if (this.viewAtTime != null) {
            this.validateFieldIsNull("includeDeleted", this.includeDeleted, fieldName);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getViewAtTime() {
        return this.viewAtTime;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public SortingCriterion getSortingCriterion() {
        return this.sortingCriterion;
    }

    public SortingDirection getSortingDirection() {
        return this.sortingDirection;
    }

    private static class V300
    extends FolderListingRequest {
        private V300() {
        }

        private V300(String path, String pageToken, Integer pageSize, Long viewAtTime, Boolean includeDeleted, SortingCriterion sortingCriterion, SortingDirection sortingDirection) {
            super(path, pageToken, pageSize, viewAtTime, includeDeleted, sortingCriterion, sortingDirection);
        }
    }

    private static class V211
    extends FolderListingRequest {
        private V211() {
        }

        private V211(String path, String pageToken, Integer pageSize) {
            super(path, pageToken, pageSize, null, null, null, null);
        }
    }

    public static enum SortingDirection {
        ASC,
        DESC;

    }

    public static enum SortingCriterion {
        NAME,
        MODIFY_DATE,
        SIZE;

    }
}

