/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FolderRestoreRequest
extends BaseFssApiResource {
    @Schema(description="The path to the folder", required=true)
    private String path;
    @Schema(description="The point in time at which to restore the folder (supplied in seconds)", required=true)
    private Integer deltaSeconds;

    public static Class<? extends FolderRestoreRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderRestoreRequest create(FssApiVersion apiVersion, String path, Integer deltaSeconds) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, deltaSeconds);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderRestoreRequest(String path, Integer deltaSeconds) {
        this.path = path;
        this.deltaSeconds = deltaSeconds;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getDeltaSeconds() {
        return this.deltaSeconds;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("deltaSeconds", this.deltaSeconds, fieldName);
    }

    private static class V300
    extends FolderRestoreRequest {
        private V300(String path, Integer deltaSeconds) {
            super(path, deltaSeconds);
        }
    }
}

