/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FolderSize
extends BaseFssApiResource {
    @Schema(description="The size of the folder in bytes", required=true)
    private Long size;

    public static Class<? extends FolderSize> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderSize create(FssApiVersion apiVersion, Long size) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(size);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderSize() {
    }

    private FolderSize(Long size) {
        this.size = size;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public Long getSize() {
        return this.size;
    }

    private static class V300
    extends FolderSize {
        private V300() {
        }

        private V300(Long size) {
            super(size);
        }
    }
}

