/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class FolderSizeRequest
extends BaseFssApiResource {
    @Schema(description="The path of the folder", required=true)
    private String path;
    @Schema(description="The point in time at which to return the folder size (must be supplied in Unix format in milliseconds)")
    private Long pointInTime;

    public static Class<? extends FolderSizeRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static FolderSizeRequest create(FssApiVersion apiVersion, String path, Long pointInTime) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, pointInTime);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private FolderSizeRequest() {
    }

    private FolderSizeRequest(String path, Long pointInTime) {
        this.path = path;
        this.pointInTime = pointInTime;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        if (this.pointInTime != null) {
            this.validateFieldInRange("pointInTime", this.pointInTime, 0L, Long.MAX_VALUE, fieldName);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Long getPointInTime() {
        return this.pointInTime;
    }

    private static class V300
    extends FolderSizeRequest {
        private V300() {
        }

        private V300(String path, Long pointInTime) {
            super(path, pointInTime);
        }
    }
}

