/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class GroupMember
extends BaseFssApiResource {
    @Schema(description="The user's username. The username is acquired from the identity provider (SAML or AD) of that user.", required=true)
    private String name;
    @Schema(description="The user's display name. The display name is acquired from the authentication provider (SAML or AD) of that user.", required=true)
    private String displayName;
    @Schema(description="The Active Directory domain that contains the user's user account", required=true)
    private String domain;

    public static Class<? extends GroupMember> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static GroupMember create(FssApiVersion apiVersion, String name, String displayName, String domain) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, name, displayName, domain);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private GroupMember() {
    }

    private GroupMember(String name, String displayName, String domain) {
        this.name = name;
        this.displayName = displayName;
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("name", this.name, fieldName);
        this.validateFieldNotNull("displayName", this.displayName, fieldName);
    }

    private static class V300
    extends GroupMember {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String name, String displayName, String domain) {
            super(name, displayName, domain);
        }
    }
}

