/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.GroupMember;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class GroupMembersListing
extends BaseFssApiResource {
    @Schema(description="A list of the members in the Active Directory group", required=true)
    private List<GroupMember> groupMembers;

    public static Class<? extends GroupMembersListing> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static GroupMembersListing create(FssApiVersion apiVersion, List<GroupMember> groupMembers) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, groupMembers);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private GroupMembersListing() {
    }

    private GroupMembersListing(List<GroupMember> groupMembers) {
        this.groupMembers = groupMembers;
    }

    public List<GroupMember> getGroupMembers() {
        return this.groupMembers;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends GroupMembersListing {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, List<GroupMember> groupMembers) {
            super(groupMembers);
        }
    }
}

