/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class ImpressumInfo
extends BaseFssApiResource {
    @Schema(description="True is impressum is enabled")
    private Boolean impressumEnabled;
    @Schema(description="Name for impressum")
    private String impressumName;
    @Schema(description="URL for impressum")
    private String impressumURL;

    public static Class<? extends ImpressumInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ImpressumInfo create(FssApiVersion apiVersion, Boolean impressumEnabled, String impressumName, String impressumURL) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(apiVersion, impressumEnabled, impressumName, impressumURL);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ImpressumInfo() {
    }

    private ImpressumInfo(Boolean impressumEnabled, String impressumName, String impressumURL) {
        this.impressumEnabled = impressumEnabled;
        this.impressumName = impressumName;
        this.impressumURL = impressumURL;
    }

    public Boolean isImpressumEnabled() {
        return this.impressumEnabled;
    }

    public String getImpressumName() {
        return this.impressumName;
    }

    public String getImpressumURL() {
        return this.impressumURL;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ImpressumInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ImpressumInfo e = (ImpressumInfo)o;
        return Objects.equal((Object)this.isImpressumEnabled(), (Object)e.isImpressumEnabled()) && Objects.equal((Object)this.getImpressumName(), (Object)e.getImpressumName()) && Objects.equal((Object)this.getImpressumURL(), (Object)e.getImpressumURL());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isImpressumEnabled(), this.getImpressumName(), this.getImpressumURL()});
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V420
    extends ImpressumInfo {
        private V420() {
        }

        private V420(FssApiVersion apiVersion, Boolean impressumEnabled, String impressumName, String impressumURL) {
            super(impressumEnabled, impressumName, impressumURL);
        }
    }
}

