/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class InviteRequest
extends BaseFssApiResource {
    @Schema(description="The path to the shared or team folder", required=true)
    private String path;
    @Schema(description="The unique identifying string assigned to the user by the user's authentication provider (AD or SAML). You can acquire a user's uniqueId using a share/invite/search request.", required=true)
    private String uniqueId;
    @Schema(description="The unique identifying string assigned to the user's authentication provider (AD or SAML) by HCP Anywhere. You can acquire a user's providerId using a share/invite/search request.", required=true)
    private String providerId;
    @Schema(description="The role of the user who is being invited to the folder: Viewer, Collaborator, or Manager", required=true)
    private ShareRole role;

    public static Class<? extends InviteRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static InviteRequest create(FssApiVersion apiVersion, String path, String uniqueId, String providerId, ShareRole role) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, uniqueId, providerId, role);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private InviteRequest() {
    }

    private InviteRequest(String path, String uniqueId, String providerId, ShareRole role) {
        this.path = path;
        this.uniqueId = uniqueId;
        this.providerId = providerId;
        this.role = role;
    }

    public String getPath() {
        return this.path;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public ShareRole getRole() {
        return this.role;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("uniqueId", this.uniqueId, fieldName);
        this.validateFieldNotNull("providerId", this.providerId, fieldName);
        this.validateFieldNotNull("role", (Object)this.role, fieldName);
    }

    private static class V300
    extends InviteRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, String uniqueId, String providerId, ShareRole role) {
            super(path, uniqueId, providerId, role);
        }
    }
}

