/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.collect.ImmutableList;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.InviteResultEntry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.util.List;

public abstract class InviteResult
extends BaseFssApiResource {
    private List<InviteResultEntry> successfulInvitations;
    private List<InviteResultEntry> failedInvitations;

    public static Class<? extends InviteResult> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static InviteResult create(FssApiVersion apiVersion, List<InviteResultEntry> successfulInvitations, List<InviteResultEntry> failedInvitations) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, successfulInvitations, failedInvitations);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private InviteResult() {
    }

    private InviteResult(List<InviteResultEntry> successfulInvitations, List<InviteResultEntry> failedInvitations) {
        this.successfulInvitations = ImmutableList.copyOf(successfulInvitations);
        this.failedInvitations = ImmutableList.copyOf(failedInvitations);
    }

    public List<InviteResultEntry> getSuccessfulInvitations() {
        return this.successfulInvitations;
    }

    public List<InviteResultEntry> getFailedInvitations() {
        return this.failedInvitations;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends InviteResult {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, List<InviteResultEntry> successfulInvitations, List<InviteResultEntry> failedInvitations) {
            super(successfulInvitations, failedInvitations);
        }
    }
}

