/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.gson.annotations.SerializedName;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkPermission;
import com.hds.hcpaw.fss.api.model.LinkType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

public abstract class Link
extends BaseFssApiResource {
    @Schema(description="The actual link", required=true)
    private String url;
    @Schema(description="The path to the file or folder where the link is pointing", required=true)
    private String path;
    private Long expirationDate;
    @Schema(description="If true, link is publicly accessible (accessible without first entering login credentials)", required=true)
    @SerializedName(value="public")
    private Boolean publicLink;
    @Schema(description="If true, the link is active", required=true)
    private Boolean accessible;
    @Schema(description="An additional code assigned to the link by HCP Anywhere", required=true)
    private String accessCode;
    @Schema(description="The type of operations a person can perform on the file or folder when accessed through the link (READ and UPLOAD)", required=true)
    private Set<LinkPermission> permissions;
    @Schema(description="A unique string assigned to the link by HCP Anywhere", required=true)
    private String token;
    @Schema(description="The type of item (FILE or FOLDER)", required=true)
    private LinkType type;
    @Schema(description="The name of the file or folder that the links points to", required=true)
    private String itemName;

    public static Class<? extends Link> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static Link create(FssApiVersion apiVersion, String url, String path, Long expiration, boolean publicLink, String accessCode, Set<LinkPermission> permission, String token, LinkType type, String itemName, boolean accessible) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, url, path, expiration, publicLink, accessCode, permission, token, type, itemName, accessible);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(apiVersion, url, path, expiration, publicLink, accessCode, permission);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private Link(String url, String path, Long expiration, boolean publicLink, String accessCode, Set<LinkPermission> permission, String token, LinkType type, String itemName, boolean accessible) {
        this.url = url;
        this.path = path;
        this.expirationDate = expiration;
        this.publicLink = publicLink;
        this.accessible = accessible;
        this.accessCode = accessCode;
        this.permissions = permission;
        this.token = token;
        this.type = type;
        this.itemName = itemName;
    }

    private Link() {
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getPath() {
        return this.path;
    }

    @Schema(name="expirationDate", description="The time at which the link expires (returned in Unix format)", required=true)
    public Long getExpiration() {
        return this.expirationDate;
    }

    public Boolean isPublicLink() {
        return this.publicLink;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public LinkType getType() {
        return this.type;
    }

    @Schema(name="permissions", description="The type of operations a person can perform on the file or folder when accessed through the link (READ and UPLOAD)", required=true)
    public Set<LinkPermission> getLinkPermissions() {
        return this.permissions;
    }

    public String getItemName() {
        return this.itemName;
    }

    public Boolean isAccessible() {
        return this.accessible;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends Link {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String url, String path, Long expiration, boolean publicLink, String accessCode, Set<LinkPermission> permission, String token, LinkType type, String itemName, boolean accessible) {
            super(url, path, expiration, publicLink, accessCode, permission, token, type, itemName, accessible);
        }
    }

    private static class V211
    extends Link {
        private V211() {
        }

        private V211(FssApiVersion apiVersion, String url, String path, Long expiration, boolean publicLink, String accessCode, Set<LinkPermission> permission) {
            super(url, path, expiration == null ? Long.MAX_VALUE : expiration, publicLink, accessCode, permission, null, null, null, true);
        }
    }
}

