/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.LinkType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class LinkBrowseListing
extends BaseFssApiResource {
    @Schema(description="If link points to a file, information about the file is returned. If link points to a folder, a list of the items (files and folders) in it is returned.", required=true)
    private List<Entry> entries;
    @Schema(description="The type of entry the link points to (FILE, FOLDER or BROKEN)")
    private LinkType linkType;
    @Schema(description="The page token identifies where in the list of items you are")
    private String pageToken;

    public static Class<? extends LinkBrowseListing> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkBrowseListing create(FssApiVersion apiVersion, List<Entry> entries, LinkType linkType, String pageToken) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(entries, linkType, pageToken);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkBrowseListing() {
    }

    private LinkBrowseListing(List<Entry> entries, LinkType linkType, String pageToken) {
        this.entries = entries;
        this.linkType = linkType;
        this.pageToken = pageToken;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends LinkBrowseListing {
        private V300() {
        }

        private V300(List<Entry> entries, LinkType linkType, String pageToken) {
            super(entries, linkType, pageToken);
        }
    }
}

