/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FolderListingRequest;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkBrowseRequest
extends LinkRequestBase {
    @Schema(description="If link points to a folder, enter \"/\" to list contents of the entire folder. To list contents of a particular subdirectory within that folder, enter the path to subdirectory. If a link points to a file, enter \"/\". Entering anything else returns an empty list.")
    private String path;
    @Schema(description="The maximum number of items to return in the request (default is 100)")
    private Integer pageSize;
    @Schema(description="The page token identifies where in the list of items you are")
    private String pageToken;
    @Schema(description="The way in which the items are sorted in the response body (NAME, MODIFY_DATE, SIZE)")
    private FolderListingRequest.SortingCriterion sortingCriterion;
    @Schema(description="The direction in which the list is sorted (ASC or DESC)")
    private FolderListingRequest.SortingDirection sortingDirection;

    public static Class<? extends LinkBrowseRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkBrowseRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, Integer pageSize, String pageToken, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(linkToken, itemName, accessCode, path, pageSize, pageToken, sortingCriterion, sortingDirection);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkBrowseRequest() {
    }

    private LinkBrowseRequest(String linkToken, String itemName, String accessCode, String path, Integer pageSize, String pageToken, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) {
        super(linkToken, itemName, accessCode);
        this.path = path;
        this.pageSize = pageSize;
        this.pageToken = pageToken;
        this.sortingCriterion = sortingCriterion;
        this.sortingDirection = sortingDirection;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public FolderListingRequest.SortingCriterion getSortingCriterion() {
        return this.sortingCriterion;
    }

    public FolderListingRequest.SortingDirection getSortingDirection() {
        return this.sortingDirection;
    }

    private static class V300
    extends LinkBrowseRequest {
        private V300() {
        }

        private V300(String linkToken, String itemName, String accessCode, String path, Integer pageSize, String pageToken, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) {
            super(linkToken, itemName, accessCode, path, pageSize, pageToken, sortingCriterion, sortingDirection);
        }
    }
}

