/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkBrowseSearchRequest
extends LinkRequestBase {
    @Schema(description="If link points to a folder, enter \"/\" to search through contents of the entire folder. To search particular subdirectory within folder, enter path to subdirectory.", required=true)
    private String path;
    @Schema(description="The string searched for in the folder. Files and folders that match or partially match the string are returned (string must be at least 3 characters long).", required=true)
    private String filter;

    public static Class<? extends LinkBrowseSearchRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkBrowseSearchRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, String filter) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(linkToken, itemName, accessCode, path, filter);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkBrowseSearchRequest() {
    }

    private LinkBrowseSearchRequest(String linkToken, String itemName, String accessCode, String path, String filter) {
        super(linkToken, itemName, accessCode);
        this.path = path;
        this.filter = filter;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("filter", this.filter, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getFilter() {
        return this.filter;
    }

    private static class V300
    extends LinkBrowseSearchRequest {
        private V300() {
        }

        private V300(String linkToken, String itemName, String accessCode, String path, String filter) {
            super(linkToken, itemName, accessCode, path, filter);
        }
    }
}

