/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class LinkCopyToLocalRequest
extends LinkRequestBase {
    @Schema(description="The path to each item that is being copied to HCP Anywhere")
    private List<String> pathList;
    @Schema(description="The path in HCP Anywhere where the files are copied to", required=true)
    private String destinationPath;

    public static Class<? extends LinkCopyToLocalRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCopyToLocalRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, List<String> pathList, String destinationPath) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, linkToken, itemName, accessCode, pathList, destinationPath);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkCopyToLocalRequest() {
    }

    private LinkCopyToLocalRequest(String linkToken, String itemName, String accessCode, List<String> pathList, String destinationPath) {
        super(linkToken, itemName, accessCode);
        this.pathList = pathList;
        this.destinationPath = destinationPath;
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("destinationPath", this.destinationPath, fieldName);
    }

    private static class V300
    extends LinkCopyToLocalRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, List<String> pathList, String destinationPath) {
            super(linkToken, itemName, accessCode, pathList, destinationPath);
        }
    }
}

