/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkCopyToLocalResultEntry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class LinkCopyToLocalResult
extends BaseFssApiResource {
    @Schema(description="A list of the items that were successfully copied to HCP Anywhere")
    private List<LinkCopyToLocalResultEntry> successfulCopies;
    @Schema(description="A list of items that failed to be copied to HCP Anywhere")
    private List<LinkCopyToLocalResultEntry> failedCopies;

    public static Class<? extends LinkCopyToLocalResult> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCopyToLocalResult create(FssApiVersion apiVersion, List<LinkCopyToLocalResultEntry> successfulCopies, List<LinkCopyToLocalResultEntry> failedCopies) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, successfulCopies, failedCopies);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkCopyToLocalResult() {
    }

    private LinkCopyToLocalResult(List<LinkCopyToLocalResultEntry> successfulCopies, List<LinkCopyToLocalResultEntry> failedCopies) {
        this.successfulCopies = successfulCopies;
        this.failedCopies = failedCopies;
    }

    public List<LinkCopyToLocalResultEntry> getSuccessfulCopies() {
        return this.successfulCopies;
    }

    public List<LinkCopyToLocalResultEntry> getFailedCopies() {
        return this.failedCopies;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends LinkCopyToLocalResult {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, List<LinkCopyToLocalResultEntry> successfulCopies, List<LinkCopyToLocalResultEntry> failedCopies) {
            super(successfulCopies, failedCopies);
        }
    }
}

