/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkCopyToLocalResultEntry
extends BaseFssApiResource {
    @Schema(description="The path where the file or folder was copied from", required=true)
    private String path;
    @Schema(description="A description of why the file or folder could not be copied to HCP Anywhere", required=true)
    private String errorMsg;
    @Schema(description="Error key if the copy is failed", required=true)
    private String error;

    public static Class<? extends LinkCopyToLocalResultEntry> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCopyToLocalResultEntry create(FssApiVersion apiVersion, String path, String errorMsg, String error) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(apiVersion, path, errorMsg, error);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, path, errorMsg);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkCopyToLocalResultEntry() {
    }

    private LinkCopyToLocalResultEntry(String path, String errorMsg, String error) {
        this.path = path;
        this.errorMsg = errorMsg;
        this.error = error;
    }

    public String getPath() {
        return this.path;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getError() {
        return this.error;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
    }

    private static class V420
    extends LinkCopyToLocalResultEntry {
        private V420() {
        }

        private V420(FssApiVersion apiVersion, String path, String errorMsg, String error) {
            super(path, errorMsg, error);
        }
    }

    private static class V300
    extends LinkCopyToLocalResultEntry {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String path, String errorMsg) {
            super(path, errorMsg, null);
        }
    }
}

