/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkPermission;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;
import java.util.Set;

public abstract class LinkCreateRequest
extends BaseFssApiResource {
    @Schema(description="The path to the file or folder where the link will point")
    private String path;
    @Schema(description="The number of days until the link expires")
    private Integer expirationDays;
    @Schema(name="public", description="If true, link is publicly accessible (accessible without first providing login credentials)")
    @SerializedName(value="public")
    private Boolean publicLink;
    @Schema(description="If true, an additional access code is created for the link", required=true)
    private boolean accessCode;
    @Schema(description="The type of operations a person can perform on the file or folder when accessed through the link", required=true)
    private Set<LinkPermission> permissions;

    public static Class<? extends LinkCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCreateRequest create(FssApiVersion apiVersion, String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, expirationDays, publicLink, accessCode, permissions);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCreateRequest create(FssApiVersion apiVersion, String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions, String uniqueId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(path, expirationDays, publicLink, accessCode, permissions, uniqueId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkCreateRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return LinkCreateRequest.fromJson(apiVersion, reader, V440.class);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return LinkCreateRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkCreateRequest() {
    }

    private LinkCreateRequest(String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions) {
        this.path = path;
        this.expirationDays = expirationDays;
        this.publicLink = publicLink;
        this.accessCode = accessCode;
        this.permissions = ImmutableSet.copyOf(permissions);
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateObjectIdentifierToLink(fieldName);
        this.validateFieldNotNull("permissions", this.permissions, fieldName);
        this.validateFieldNotNull("accessCode", this.accessCode, fieldName);
    }

    protected abstract void validateObjectIdentifierToLink(String var1) throws AwJsonException;

    public String getPath() {
        return this.path;
    }

    public Integer getExpirationDays() {
        return this.expirationDays;
    }

    public Boolean isPublicLink() {
        return this.publicLink;
    }

    public boolean hasAccessCode() {
        return this.accessCode;
    }

    public Set<LinkPermission> getPermissions() {
        return this.permissions;
    }

    public abstract String getObjectIdentifier();

    public abstract boolean hasUniqueId();

    private static class V440
    extends LinkCreateRequest {
        @Schema(description="The unique id to the file or folder where the link will point", required=true)
        private String uniqueId;

        private V440() {
        }

        private V440(String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions, String uniqueId) {
            super(path, expirationDays, publicLink, accessCode, permissions);
            this.uniqueId = uniqueId;
        }

        @Override
        public String getObjectIdentifier() {
            return this.hasUniqueId() ? this.uniqueId : this.getPath();
        }

        @Override
        public boolean hasUniqueId() {
            return this.uniqueId != null;
        }

        @Override
        protected void validateObjectIdentifierToLink(String fieldName) throws AwJsonException {
            String path = this.getPath();
            if (this.uniqueId == null) {
                this.validateFieldNotNull("path", this.getPath(), fieldName);
            }
        }
    }

    private static class V211
    extends LinkCreateRequest {
        private V211() {
        }

        private V211(String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions) {
            super(path, expirationDays, publicLink, accessCode, permissions);
        }

        @Override
        public String getObjectIdentifier() {
            return this.getPath();
        }

        @Override
        public boolean hasUniqueId() {
            return false;
        }

        @Override
        protected void validateObjectIdentifierToLink(String fieldName) throws AwJsonException {
            this.validateFieldNotNull("path", this.getPath(), fieldName);
        }
    }
}

