/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class LinkDeleteRequest
extends BaseFssApiResource {
    @Schema(description="The actual link", required=true)
    private String url;

    public static Class<? extends LinkDeleteRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkDeleteRequest create(FssApiVersion apiVersion, String path, String url) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, url);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkDeleteRequest create(FssApiVersion apiVersion, String url) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(url);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkDeleteRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return LinkDeleteRequest.fromJson(apiVersion, reader, V440.class);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return LinkDeleteRequest.fromJson(apiVersion, reader, V300.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkDeleteRequest() {
    }

    private LinkDeleteRequest(String url) {
        this.url = url;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("url", this.url, fieldName);
    }

    public String getUrl() {
        return this.url;
    }

    private static class V440
    extends LinkDeleteRequest {
        private V440() {
        }

        private V440(String url) {
            super(url);
        }
    }

    private static class V300
    extends LinkDeleteRequest {
        @Schema(description="The path to the file or folder where the link is pointing", required=true)
        private String path;

        private V300() {
        }

        private V300(String path, String url) {
            super(url);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
            super.validate(fieldName, parent);
            this.validateFieldNotNull("path", this.path, fieldName);
        }
    }
}

