/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStream;

public abstract class LinkFileCreateRequest
extends LinkRequestBase {
    @Schema(description="The path of the file you want to upload", required=true)
    private String path;
    @Schema(description="The size (in bytes) of the file being uploaded", required=true)
    private Long size;
    @Schema(description="The hex encoded SHA-384 hash of the file being uploaded", required=true)
    private String hash;
    @Schema(description="True if any parent folders of path that do not already exist should be created; false otherwise")
    private Boolean createParents;
    @Schema(description="The creation time of the file")
    private Long ctime;
    @Schema(description="The modification time of the file")
    private Long mtime;
    @Schema(description="The last access time of the file")
    private Long atime;
    @Schema(description="The InputStream (file) to be uploaded", required=true)
    private InputStream input;

    public static Class<? extends LinkFileCreateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkFileCreateRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, Long atime, Long ctime, Long mtime, InputStream input) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(linkToken, itemName, accessCode, path, size, hash, createParents, atime, ctime, mtime, input);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(linkToken, itemName, accessCode, path, size, hash, createParents, input);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkFileCreateRequest() {
    }

    private LinkFileCreateRequest(String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, Long atime, Long ctime, Long mtime, InputStream input) {
        super(linkToken, itemName, accessCode);
        this.path = path;
        this.size = size;
        this.hash = hash;
        this.createParents = createParents;
        this.atime = atime;
        this.ctime = ctime;
        this.mtime = mtime;
        this.input = input;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("input", this.input, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public Boolean getCreateParents() {
        return this.createParents;
    }

    public InputStream getInput() {
        return this.input;
    }

    public Long getMTime() {
        return this.mtime;
    }

    public Long getCTime() {
        return this.ctime;
    }

    public Long getATime() {
        return this.atime;
    }

    private static class V300
    extends LinkFileCreateRequest {
        private V300() {
        }

        private V300(String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, InputStream input) {
            super(linkToken, itemName, accessCode, path, size, hash, createParents, null, null, null, input);
        }
    }

    private static class V420
    extends LinkFileCreateRequest {
        private V420() {
        }

        private V420(String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, Long atime, Long ctime, Long mtime, InputStream input) {
            super(linkToken, itemName, accessCode, path, size, hash, createParents, atime, ctime, mtime, input);
        }
    }
}

