/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkFileReadRequest
extends LinkRequestBase {
    @Schema(description="The path to the file", required=true)
    private String path;
    @Schema(description="The etag identifies the version of the file")
    private String etag;

    public static Class<? extends LinkFileReadRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkFileReadRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, String etag) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(linkToken, itemName, accessCode, path, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkFileReadRequest() {
    }

    private LinkFileReadRequest(String linkToken, String itemName, String accessCode, String path, String etag) {
        super(linkToken, itemName, accessCode);
        this.path = path;
        this.etag = etag;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("path", this.path, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public String getEtag() {
        return this.etag;
    }

    private static class V300
    extends LinkFileReadRequest {
        private V300() {
        }

        private V300(String linkToken, String itemName, String accessCode, String path, String etag) {
            super(linkToken, itemName, accessCode, path, etag);
        }
    }
}

