/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStream;

public abstract class LinkFileUpdateRequest
extends LinkRequestBase {
    @Schema(description="The path in the folder where the file is uploaded", required=true)
    private String path;
    @Schema(description="The size (in bytes) of the file being uploaded")
    private Long size;
    @Schema(description="The hex encoded SHA-384 hash of the file being uploaded")
    private String hash;
    @Schema(description="The etag identifies the version of the file and is part of the file metadata")
    private String etag;
    @Schema(description="The modification time of the file or folder (supplied in Unix Epoch time)")
    private Long mtime;
    @Schema(description="The last access time of the file or folder (supplied in Unix Epoch time)")
    private Long atime;
    @Schema(description="InputStream containing content to update the file with")
    private InputStream input;

    public static Class<? extends LinkFileUpdateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkFileUpdateRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, Long atime, Long mtime, InputStream input) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(apiVersion, linkToken, itemName, accessCode, path, size, hash, etag, atime, mtime, input);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, linkToken, itemName, accessCode, path, size, hash, etag, input);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkFileUpdateRequest() {
    }

    private LinkFileUpdateRequest(String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, Long atime, Long mtime, InputStream input) {
        super(linkToken, itemName, accessCode);
        this.path = path;
        this.size = size;
        this.hash = hash;
        this.etag = etag;
        this.atime = atime;
        this.mtime = mtime;
        this.input = input;
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getMTime() {
        return this.mtime;
    }

    public Long getATime() {
        return this.atime;
    }

    public InputStream getInput() {
        return this.input;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("etag", this.etag, fieldName);
        this.validateFieldNotNull("input", this.input, fieldName);
    }

    private static class V300
    extends LinkFileUpdateRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, InputStream input) {
            super(linkToken, itemName, accessCode, path, size, hash, etag, null, null, input);
        }
    }

    private static class V420
    extends LinkFileUpdateRequest {
        private V420() {
        }

        private V420(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, Long atime, Long mtime, InputStream input) {
            super(linkToken, itemName, accessCode, path, size, hash, etag, atime, mtime, input);
        }
    }
}

