/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.FolderListingRequest;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkListRequest
extends BaseFssApiResource {
    @Schema(description="The page token identifies where in the list of you are")
    private String pageToken;
    @Schema(description="The maximum number of items to return in the request (default is 100)")
    private Integer pageSize;
    @Schema(description="The way in which the links are sorted in the response body (NAME, EXPIRATION, PERMISSIONS, PUBLIC, HAS_ACCESS_CODE)")
    private LinkSortingCriterion sortingCriterion;
    @Schema(description="The direction in which the links are sorted (ASC or DESC)")
    private FolderListingRequest.SortingDirection sortingDirection;
    @Schema(description="The search criteria")
    private String filter;

    public static Class<? extends LinkListRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkListRequest create(FssApiVersion apiVersion, String pageToken, Integer pageSize, LinkSortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection, String filter) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, pageToken, pageSize, sortingCriterion, sortingDirection, filter);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkListRequest(String pageToken, Integer pageSize, LinkSortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection, String filter) {
        this.pageToken = pageToken;
        this.pageSize = pageSize;
        this.sortingCriterion = sortingCriterion;
        this.sortingDirection = sortingDirection;
        this.filter = filter;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        if (this.pageSize != null) {
            this.validateFieldInRange("pageSize", this.pageSize, 1, Integer.MAX_VALUE, null);
        }
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public LinkSortingCriterion getSortingCriterion() {
        return this.sortingCriterion;
    }

    public FolderListingRequest.SortingDirection getSortingDirection() {
        return this.sortingDirection;
    }

    public String getFilter() {
        return this.filter;
    }

    private static class V300
    extends LinkListRequest {
        private V300(FssApiVersion apiVersion, String pageToken, Integer pageSize, LinkSortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection, String filter) {
            super(pageToken, pageSize, sortingCriterion, sortingDirection, filter);
        }
    }

    public static enum LinkSortingCriterion {
        NAME,
        EXPIRATION,
        PERMISSIONS,
        PUBLIC,
        HAS_ACCESS_CODE;

    }
}

