/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Link;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class LinkListing
extends BaseFssApiResource {
    @Schema(description="A list of the user's active links", required=true)
    private List<Link> links;
    @Schema(description="A page token is returned in every response and identifies where in the list of links you are", required=true)
    private String pageToken;

    public static Class<? extends LinkListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static LinkListing create(FssApiVersion apiVersion, List<Link> links, String pageToken) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(links, pageToken);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkListing(List<Link> links, String pageToken) {
        this.links = links;
        this.pageToken = pageToken;
    }

    private LinkListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    private static class V300
    extends LinkListing {
        private V300() {
        }

        private V300(List<Link> links, String pageToken) {
            super(links, pageToken);
        }
    }
}

