/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkPermission;
import com.hds.hcpaw.fss.api.model.LinkType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

public abstract class LinkMetadata
extends BaseFssApiResource {
    @Schema(description="If true, the file or folder that the link points to cannot be accessed without the link's access code", required=true)
    private Boolean requiresAccessCode;
    private Set<LinkPermission> permissions;
    @Schema(description="The type of item (FILE, FOLDER, or BROKEN)", required=true)
    private LinkType type;
    @Schema(description="If item is a file, format of the file is returned (ex. \"audio/mp3\", \"image/jpeg\"). If file is an audio or video file over 5 MB, not a recognized file format, or link preview is disabled by the HCP Anywhere administrator, contentType is always \"application/octet-stream\". If item is a folder, contentType field is not returned in the response body.")
    private String contentType;
    @Schema(description="If the item is a file, the size of the file in bytes")
    private Long size;
    @Schema(description="Owner of the link")
    private String linkOwner;
    @Schema(description="Current name of the file or folder of the link")
    private String name;

    public static Class<? extends LinkMetadata> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return V303.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static LinkMetadata create(FssApiVersion apiVersion, Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType, Long size, String linkOwner, String name) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(apiVersion, requiresAccessCode, permission, type, contentType, size, linkOwner, name);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return new V310(apiVersion, requiresAccessCode, permission, type, contentType, size, linkOwner);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, requiresAccessCode, permission, type, contentType, size);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, requiresAccessCode, permission, type, contentType);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkMetadata(Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType, Long size, String linkOwner, String name) {
        this.requiresAccessCode = requiresAccessCode;
        this.permissions = permission;
        this.type = type;
        this.contentType = contentType;
        this.size = size;
        this.linkOwner = linkOwner;
        this.name = name;
    }

    private LinkMetadata() {
    }

    public Boolean getRequiresAccessCode() {
        return this.requiresAccessCode;
    }

    public LinkType getType() {
        return this.type;
    }

    @Schema(name="permissions", description="The type of operations a person can perform on the file or folder when accessed through the link (READ and UPLOAD)")
    public Set<LinkPermission> getLinkPermissions() {
        return this.permissions;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getSize() {
        return this.size;
    }

    public String getLinkOwner() {
        return this.linkOwner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends LinkMetadata {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType) {
            super(requiresAccessCode, permission, type, contentType, null, null, null);
        }
    }

    private static class V303
    extends LinkMetadata {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType, Long size) {
            super(requiresAccessCode, permission, type, contentType, size, null, null);
        }
    }

    private static class V310
    extends LinkMetadata {
        private V310() {
        }

        private V310(FssApiVersion apiVersion, Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType, Long size, String linkOwner) {
            super(requiresAccessCode, permission, type, contentType, size, linkOwner, null);
        }
    }

    private static class V440
    extends LinkMetadata {
        private V440() {
        }

        private V440(FssApiVersion apiVersion, Boolean requiresAccessCode, Set<LinkPermission> permission, LinkType type, String contentType, Long size, String linkOwner, String name) {
            super(requiresAccessCode, permission, type, contentType, size, linkOwner, name);
        }
    }
}

