/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class LinkMetadataRequest
extends BaseFssApiResource {
    @Schema(description="The name of the file or folder where the link is pointing", required=true)
    private String itemName;
    @Schema(description="A unique string assigned to the link by HCP Anywhere", required=true)
    private String linkToken;

    public static Class<? extends LinkMetadataRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkMetadataRequest create(FssApiVersion apiVersion, String itemName, String linkToken) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, itemName, linkToken);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkMetadataRequest(String itemName, String linkToken) {
        this.itemName = itemName;
        this.linkToken = linkToken;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("itemName", this.itemName, fieldName);
        this.validateFieldNotNull("linkToken", this.linkToken, fieldName);
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getLinkToken() {
        return this.linkToken;
    }

    private static class V300
    extends LinkMetadataRequest {
        private V300(FssApiVersion apiVersion, String itemName, String linkToken) {
            super(itemName, linkToken);
        }
    }
}

