/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class LinkMultiDownloadRequest
extends LinkRequestBase {
    @Schema(description="The path to each item that is being downloaded", required=true)
    private List<String> pathList;

    public static Class<? extends LinkMultiDownloadRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkMultiDownloadRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, List<String> pathList) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, linkToken, itemName, accessCode, pathList);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkMultiDownloadRequest() {
    }

    private LinkMultiDownloadRequest(String linkToken, String itemName, String accessCode, List<String> pathList) {
        super(linkToken, itemName, accessCode);
        this.pathList = pathList;
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        super.validate(fieldName, parent);
        this.validateFieldNotNull("pathList", this.pathList, fieldName);
    }

    private static class V300
    extends LinkMultiDownloadRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, List<String> pathList) {
            super(linkToken, itemName, accessCode, pathList);
        }
    }
}

