/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.LinkRequestBase;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class LinkPathMetadataRequest
extends LinkRequestBase {
    @Schema(description="The path to the file or folder to return metadata about", required=true)
    private String path;

    public static Class<? extends LinkPathMetadataRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkPathMetadataRequest create(FssApiVersion apiVersion, String linkToken, String itemName, String accessCode, String path) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(linkToken, itemName, accessCode, path);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkPathMetadataRequest() {
    }

    private LinkPathMetadataRequest(String linkToken, String itemName, String accessCode, String path) {
        super(linkToken, itemName, accessCode);
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    private static class V300
    extends LinkPathMetadataRequest {
        private V300() {
        }

        private V300(String linkToken, String itemName, String accessCode, String path) {
            super(linkToken, itemName, accessCode, path);
        }
    }
}

