/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public class LinkSettings
extends BaseFssApiResource {
    @Schema(description="Whether sharing has been enabled")
    private Boolean readEnabled;
    @Schema(description="Whether public sharing has been enabled")
    private Boolean publicReadEnabled;
    @Schema(description="Whether upload links have been enabled")
    private Boolean uploadEnabled;
    @Schema(description="Whether public upload links have been enabled")
    private Boolean publicUploadEnabled;
    @Schema(description="Whether edit links have been enabled")
    private Boolean editEnabled;
    @Schema(description="Whether or not the server is configured to share links publicly by default")
    private Boolean sharingDefaultPublic;
    @Schema(description="The default number of days before a link expires")
    private Integer defaultDaysToShare;
    @Schema(description="The maximum number of days a link can remain active")
    private Integer maxDaysToShare;
    @Schema(description="Whether links are allowed to be created without an expiration")
    private Boolean allowLinksWithoutExpiration;
    @Schema(description="Whether or not sharing is enabled on the server")
    private Boolean sharingEnabled;
    @Schema(description="Whether or not the server is configured to share links publicly by default")
    private Boolean publicSharingEnabled;
    @Schema(description="Whether or not the server mandates that all links have access codes")
    private Boolean accessCodeOnAllLinksRequired;
    @Schema(description="Whether or not the server mandates that public links have access codes")
    private Boolean accessCodeOnPublicLinksRequired;

    public static Class<? extends LinkSettings> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static LinkSettings create(FssApiVersion apiVersion, Boolean readEnabled, Boolean publicReadEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean editEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare, Boolean allowLinksWithoutExpiration, Boolean requireAccessCodeOnAllLinks, Boolean requireAccessCodeOnPublicLinks) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(apiVersion, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, editEnabled, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration, requireAccessCodeOnAllLinks, requireAccessCodeOnPublicLinks);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return new V310(apiVersion, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration, requireAccessCodeOnAllLinks, requireAccessCodeOnPublicLinks);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(apiVersion, null, null, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkSettings(Boolean sharingEnabled, Boolean publicSharingEnabled, Boolean readEnabled, Boolean publicReadEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean editEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare, Boolean allowLinksWithoutExpiration, Boolean accessCodeOnAllLinksRequired, Boolean accessCodeOnPublicLinksRequired) {
        this.sharingEnabled = sharingEnabled;
        this.publicSharingEnabled = publicSharingEnabled;
        this.readEnabled = readEnabled;
        this.publicReadEnabled = publicReadEnabled;
        this.uploadEnabled = uploadEnabled;
        this.publicUploadEnabled = publicUploadEnabled;
        this.editEnabled = editEnabled;
        this.sharingDefaultPublic = sharingDefaultPublic;
        this.defaultDaysToShare = defaultDaysToShare;
        this.maxDaysToShare = maxDaysToShare;
        this.allowLinksWithoutExpiration = allowLinksWithoutExpiration;
        this.accessCodeOnAllLinksRequired = accessCodeOnAllLinksRequired;
        this.accessCodeOnPublicLinksRequired = accessCodeOnPublicLinksRequired;
    }

    private LinkSettings() {
    }

    public Boolean isReadEnabled() {
        return this.readEnabled;
    }

    public Boolean isPublicReadEnabled() {
        return this.publicReadEnabled;
    }

    public Boolean isUploadEnabled() {
        return this.uploadEnabled;
    }

    public Boolean isPublicUploadEnabled() {
        return this.publicUploadEnabled;
    }

    public Boolean isEditEnabled() {
        return this.editEnabled;
    }

    public Boolean isSharingPublicByDefault() {
        return this.sharingDefaultPublic;
    }

    public int getSharingDefaultDays() {
        return this.defaultDaysToShare;
    }

    public int getMaxSharingDays() {
        return this.maxDaysToShare;
    }

    public Boolean isAllowLinksWithoutExpiration() {
        return this.allowLinksWithoutExpiration == null ? false : this.allowLinksWithoutExpiration;
    }

    public Boolean isSharingEnabled() {
        return this.sharingEnabled;
    }

    public Boolean isPublicSharingEnabled() {
        return this.publicSharingEnabled;
    }

    public Boolean isAccessCodeOnAllLinksRequired() {
        return this.accessCodeOnAllLinksRequired;
    }

    public Boolean isAccessCodeOnPublicLinksRequired() {
        return this.accessCodeOnPublicLinksRequired;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V440
    extends LinkSettings {
        private V440() {
        }

        private V440(FssApiVersion apiVersion, Boolean readEnabled, Boolean publicReadEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean editEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare, Boolean allowLinksWithoutExpiration, Boolean requireAccessCodeOnAllLinks, Boolean requireAccessCodeOnPublicLinks) {
            super(null, null, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, editEnabled, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration, requireAccessCodeOnAllLinks, requireAccessCodeOnPublicLinks);
        }
    }

    private static class V310
    extends LinkSettings {
        private V310() {
        }

        private V310(FssApiVersion apiVersion, Boolean readEnabled, Boolean publicReadEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare, Boolean allowLinksWithoutExpiration, Boolean requireAccessCodeOnAllLinks, Boolean requireAccessCodeOnPublicLinks) {
            super(null, null, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, null, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration, requireAccessCodeOnAllLinks, requireAccessCodeOnPublicLinks);
        }
    }

    private static class V300
    extends LinkSettings {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean readEnabled, Boolean publicReadEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare, Boolean allowLinksWithoutExpiration) {
            super(null, null, readEnabled, publicReadEnabled, uploadEnabled, publicUploadEnabled, null, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, allowLinksWithoutExpiration, null, null);
        }
    }

    private static class V211
    extends LinkSettings {
        private V211() {
        }

        private V211(FssApiVersion apiVersion, Boolean readEnabled, Boolean publicReadEnabled, Boolean sharingEnabled, Boolean publicSharingEnabled, Boolean uploadEnabled, Boolean publicUploadEnabled, Boolean sharingDefaultPublic, int defaultDaysToShare, int maxDaysToShare) {
            super(sharingEnabled, publicSharingEnabled, null, null, uploadEnabled, publicUploadEnabled, null, sharingDefaultPublic, defaultDaysToShare, maxDaysToShare, null, null, null);
        }
    }
}

