/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class LinkUpdateRequest
extends BaseFssApiResource {
    @Schema(description="The actual link", required=true)
    private String url;
    @Schema(description="If true, a new access code is created for the link", required=true)
    private Boolean updateAccessCode;
    @Schema(description="The new time at which the link expires (supplied in Unix millisecond format)")
    private Long expirationDate;

    public static Class<? extends LinkUpdateRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkUpdateRequest create(FssApiVersion apiVersion, String path, String url, Boolean updateAccessCode, Long expirationDate) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(path, url, updateAccessCode, expirationDate);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkUpdateRequest create(FssApiVersion apiVersion, String url, Boolean updateAccessCode, Long expirationDate) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(url, updateAccessCode, expirationDate);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static LinkUpdateRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return LinkUpdateRequest.fromJson(apiVersion, reader, V440.class);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return LinkUpdateRequest.fromJson(apiVersion, reader, V300.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private LinkUpdateRequest() {
    }

    private LinkUpdateRequest(String url, Boolean updateAccessCode, Long expirationDate) {
        this.url = url;
        this.updateAccessCode = updateAccessCode;
        this.expirationDate = expirationDate;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("url", this.url, fieldName);
        this.validateFieldNotNull("accessCode", this.updateAccessCode, fieldName);
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getUpdateAccessCode() {
        return this.updateAccessCode;
    }

    public Long getExpirationDate() {
        return this.expirationDate;
    }

    private static class V440
    extends LinkUpdateRequest {
        private V440() {
        }

        private V440(String url, Boolean updateAccessCode, Long expirationDate) {
            super(url, updateAccessCode, expirationDate);
        }
    }

    private static class V300
    extends LinkUpdateRequest {
        @Schema(description="The path to the file or folder where the link is pointing", required=true)
        private String path;

        private V300() {
        }

        private V300(String path, String url, Boolean updateAccessCode, Long expirationDate) {
            super(url, updateAccessCode, expirationDate);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
            super.validate(fieldName, parent);
            this.validateFieldNotNull("path", this.path, fieldName);
        }
    }
}

