/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ListGroupMembersRequest
extends BaseFssApiResource {
    @Schema(description="The name of the Active Directory group", required=true)
    private String name;
    @Schema(description="The unique identifying string assigned to the group's authentication provider (AD or SAML) by HCP Anywhere. You can acquire the uniqueId of a group using a share/invite/search request.")
    private String providerId;

    public static Class<? extends ListGroupMembersRequest> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ListGroupMembersRequest create(FssApiVersion apiVersion, String name, String providerId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, name, providerId);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ListGroupMembersRequest() {
    }

    private ListGroupMembersRequest(String name, String providerId) {
        this.name = name;
        this.providerId = providerId;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderId() {
        return this.providerId;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("name", this.name, fieldName);
    }

    private static class V300
    extends ListGroupMembersRequest {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String name, String providerId) {
            super(name, providerId);
        }
    }
}

