/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class MovePathRequest
extends BaseFssApiResource {
    @Schema(description="The current path of the file or folder that you want to move", required=true)
    private String sourcePath;
    @Schema(description="The path where the file or folder will be moved. If a different name is entered for the last item in the path, the file or folder is renamed.", required=true)
    private String destinationPath;
    @Schema(description="The etag of the file or folder. The etag identifies the version of the file or folder and is part of the file or folder metadata.", required=true)
    private String etag;
    @Schema(description="If true, the request creates any folders that do not exist in the path you specified in the destinationPath parameter. If false, the request fails if any folders in the path do not exist. The default is false.")
    private Boolean createParents;

    public static Class<? extends MovePathRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static MovePathRequest create(FssApiVersion apiVersion, String sourcePath, String destinationPath, String etag, Boolean createParents) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(sourcePath, destinationPath, etag, createParents);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static MovePathRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return MovePathRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private MovePathRequest() {
    }

    private MovePathRequest(String sourcePath, String destPath, String etag, Boolean createParents) {
        this.sourcePath = sourcePath;
        this.destinationPath = destPath;
        this.etag = etag;
        this.createParents = createParents;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("sourcePath", this.sourcePath, fieldName);
        this.validateFieldNotNull("destinationPath", this.destinationPath, fieldName);
        this.validateFieldNotNull("etag", this.etag, fieldName);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public String getEtag() {
        return this.etag;
    }

    public Boolean getCreateParents() {
        return this.createParents;
    }

    private static class V211
    extends MovePathRequest {
        private V211() {
        }

        private V211(String sourcePath, String destPath, String etag, Boolean createParents) {
            super(sourcePath, destPath, etag, createParents);
        }
    }
}

